String data="";
String fileConfig = "/config.json";
using namespace std;
vector<String> v;

String readFile(fs::FS &fs, String filename){
  Serial.println("readFile -> Reading file: " + filename);

  File file = fs.open(filename);
  if(!file || file.isDirectory()){
    Serial.println("readFile -> failed to open file for reading");
    return "";
  }

  String fileText = "";
  while(file.available()){
    fileText = file.readString();
  }

  file.close();
  return fileText;
}

String readConfig(String file_name) {
  String file_content = readFile(SPIFFS, file_name);

  int config_file_size = file_content.length();
  Serial.println("Config file size: " + String(config_file_size));

  if(config_file_size > 1024) {
    Serial.println("Config file too large");
  }
  StaticJsonDocument<1024> doc;
  auto error = deserializeJson(doc, file_content);
  if ( error ) { 
    Serial.println("Error interpreting config file");
  }

  String _data = doc["data"];

  data = _data;

  Serial.print("Read config:");   
  Serial.println(data);
  return data;
}

void writeFile(fs::FS &fs, String filename, String message){
  Serial.println("writeFile -> Writing file: " + filename);

  File file = fs.open(filename, FILE_WRITE);
  if(!file){
    Serial.println("writeFile -> failed to open file for writing");
    return;
  }
  if(file.print(message)){
    Serial.println("writeFile -> file written");
  } else {
    Serial.println("writeFile -> write failed");
  }
  file.close();
}

bool saveConfig(String file_name) {
  StaticJsonDocument<1024> doc;

  // write variables to JSON file
  doc["data"] = data;
  
  // write config file
  String tmp = "";
  serializeJson(doc, tmp);
  writeFile(SPIFFS, file_name, tmp);
  
  return true;
}

String valConfig(){
  data = readConfig(fileConfig);
  
  String result = String(data);
  Serial.print("Data send to config UI: ");
  Serial.println(result);
  return result;
}