#include "FS.h"
#include "SD.h"
#include "SPI.h"

#include "Arduino.h"
#include <WiFi.h>
#include <ESPAsyncWebServer.h>
#include <ESP32AnalogRead.h>
#include <math.h>

#include <SPIFFS.h>
#include <ArduinoJson.h>

#include <PubSubClient.h>

#include <Wire.h>
#include <htmlui.h>
#include <spffis.h>

#define FORMAT_SPIFFS_IF_FAILED true

#define ENABLE_GxEPD2_GFX 0

#include <GxEPD2_BW.h>
#include <GxEPD2_3C.h>
#include <GxEPD2_7C.h>
#include <Fonts/FreeMonoBold9pt7b.h>
#include "bitmaps/Bitmaps1304x984.h" // 12.48" b/w

#define SLEEP_SEC 15         // Measurement interval (seconds)


const char* ssid = "ePaper";
const char* password = "12345678";

AsyncWebServer server(80);

GxEPD2_BW<GxEPD2_750_T7, GxEPD2_750_T7::HEIGHT> display(GxEPD2_750_T7(/*CS=5*/ SS, /*DC=*/ 17, /*RST=*/ 16, /*BUSY=*/ 4)); // GDEY075T7 800x480, GDEW075T7, Waveshare 7.5"

void helloWorld(String data)
{
  //Serial.println("helloWorld");
  display.setRotation(3);
  display.setFont(&FreeMonoBold9pt7b);
  if (display.epd2.WIDTH < 104) display.setFont(0);
  display.setTextColor(GxEPD_BLACK);
  int16_t tbx, tby; uint16_t tbw, tbh;
  display.getTextBounds(data, 0, 0, &tbx, &tby, &tbw, &tbh);
  // center bounding box by transposition of origin:
  uint16_t x = ((display.width() - tbw) / 2) - tbx;
  uint16_t y = ((display.height() - tbh) / 2) - tby;
  display.setFullWindow();
  display.firstPage();
  do
  {
    display.fillScreen(GxEPD_WHITE);
    display.setCursor(x, y);
    display.print(data);
  }
  while (display.nextPage());
  //Serial.println("helloWorld done");
}

void setup()
{
  Serial.begin(115200);

  // Server
  WiFi.softAP(ssid, password);

  IPAddress IP = WiFi.softAPIP();
  Serial.print("AP IP address: ");
  Serial.println(IP);

  if(!SPIFFS.begin(FORMAT_SPIFFS_IF_FAILED)){
    Serial.println("SPIFFS Mount Failed");
    return;
  }
  server.on("/", HTTP_GET, [](AsyncWebServerRequest *request){
    request->send_P(200, "text/html", index_html);
  });

  server.on("/getdata", HTTP_GET, [] (AsyncWebServerRequest *request) {
    request->send(200, "text/plain", valConfig().c_str());
  });

  server.on("/setdata", HTTP_GET, [] (AsyncWebServerRequest *request) {
    int params = request->params();
    for(int i=0;i<params;i++){
      AsyncWebParameter* p = request->getParam(i);
      if (p->name() == "data" ) {
        data = p->value();
        helloWorld(data);
      }
    }
 
    saveConfig(fileConfig);
    request->send(200, "text/plain", "OK");
  });

  Serial.println();
  Serial.println("setup");
  delay(100);

  server.begin();
  Serial.println("HTTP server started");

  data = readConfig(fileConfig);

// turn on power to display
  pinMode(2, OUTPUT);
  digitalWrite(2, HIGH);   // turn the LED on (HIGH is the voltage level)
  Serial.println("Display power ON");
  delay(1000);   
  
  display.init(); // inicializace

  display.fillScreen(GxEPD_WHITE);
  delay(1000);
  // first update should be full refresh
  helloWorld(data);
  delay(1000);
  /*
  // partial refresh mode can be used to full screen,
  // effective if display panel hasFastPartialUpdate
  //* helloFullScreenPartialMode();
  //* delay(1000);
  //stripeTest(); return; // GDEH029Z13 issue
  //* helloArduino();
  //* delay(1000);
  //* helloEpaper();
  //* delay(1000);
  //helloValue(123.9, 1);
  //delay(1000);
  //* showFont("FreeMonoBold9pt7b", &FreeMonoBold9pt7b);
  delay(1000);
  if (display.epd2.WIDTH < 104)
  {
    //* showFont("glcdfont", 0);
   //*  delay(1000);
  }
 //*  drawBitmaps();

  if (display.epd2.panel == GxEPD2::ACeP565)
  {
    //draw7colorlines();
    //delay(2000);
    //* draw7colors();
    //* delay(4000);
  }

  if (display.epd2.hasPartialUpdate)
  {
    //* showPartialUpdate();
    //* delay(1000);
  } // else // on GDEW0154Z04 only full update available, doesn't look nice
  //drawCornerTest();
  //showBox(16, 16, 48, 32, false);
  //showBox(16, 56, 48, 32, true);
  //* display.powerOff();
 //* deepSleepTest();

  //* drawBitmaps1304x984();
  */
  display.powerOff();

  Serial.println("Setup done");

}


void loop()
{
}