const char index_html[] PROGMEM = R"rawliteral(
 <!DOCTYPE HTML><html>
    <head>
      <title>ESP Web Server</title>
      <meta name="viewport" content="width=device-width, initial-scale=1">
      <style>

            html {
                box-sizing: border-box;
                -ms-overflow-style: scrollbar;
            }

                *,
                *::before,
                *::after {
                box-sizing: inherit;
            }
            .container{
                width: 100%;
                padding-right: 15px;
                padding-left: 15px;
                margin-right: auto;
                margin-left: auto;
            }

            .row {
                display: -ms-flexbox;
                display: flex;
                -ms-flex-wrap: wrap;
                flex-wrap: wrap;
                margin-right: -15px;
                margin-left: -15px;
            }

            .no-gutters {
                margin-right: 0;
                margin-left: 0;
            }

            .no-gutters > .col,
            .no-gutters > [class*="col-"] {
                padding-right: 0;
                padding-left: 0;
            }

            .col-1, .col-2, .col-3, .col-4, .col-5, .col-6, .col-7, .col-8, .col-9, .col-10, .col-11, .col-12, .col,
            .col-auto {
                position: relative;
                width: 100%;
                padding-right: 15px;
                padding-left: 15px;
            }

            .col {
                -ms-flex-preferred-size: 0;
                flex-basis: 0;
                -ms-flex-positive: 1;
                flex-grow: 1;
                max-width: 100%;
            }
            .col-auto {-ms-flex: 0 0 auto; flex: 0 0 auto;width: auto;max-width: 100%;}
            .col-1 {-ms-flex: 0 0 8.333333%;flex: 0 0 8.333333%; max-width: 8.333333%;}
            .col-2 {-ms-flex: 0 0 16.666667%;flex: 0 0 16.666667%;max-width: 16.666667%;}
            .col-3 {-ms-flex: 0 0 25%;flex: 0 0 25%; max-width: 25%;}
            .col-4 { -ms-flex: 0 0 33.333333%;flex: 0 0 33.333333%; max-width: 33.333333%;}
            .col-5 {-ms-flex: 0 0 41.666667%;flex: 0 0 41.666667%;max-width: 41.666667%; }
            .col-6 {-ms-flex: 0 0 50%;flex: 0 0 50%; max-width: 50%;}
            .col-7 {-ms-flex: 0 0 58.333333%;flex: 0 0 58.333333%;max-width: 58.333333%;}
            .col-8 {-ms-flex: 0 0 66.666667%;flex: 0 0 66.666667%;max-width: 66.666667%;}
            .col-9 { -ms-flex: 0 0 75%;flex: 0 0 75%; max-width: 75%; }
            .col-10 {-ms-flex: 0 0 83.333333%;flex: 0 0 83.333333%;max-width: 83.333333%;}
            .col-11 {-ms-flex: 0 0 91.666667%;flex: 0 0 91.666667%;max-width: 91.666667%;}
            .col-12 {-ms-flex: 0 0 100%;flex: 0 0 100%; max-width: 100%; }

            .m-0 {margin: 0 !important;}
            .mt-0,.my-0 {margin-top: 0 !important; }
            .mr-0,.mx-0 {margin-right: 0 !important;}
            .mb-0,.my-0 {margin-bottom: 0 !important;}
            .ml-0,.mx-0 {margin-left: 0 !important;}
            .m-1 { margin: 0.25rem !important;}
            .mt-1, .my-1 { margin-top: 0.25rem !important; }
            .mr-1,.mx-1 { margin-right: 0.25rem !important;}
            .mb-1, .my-1 {margin-bottom: 0.25rem !important; }
            .ml-1,.mx-1 {margin-left: 0.25rem !important; }
            .m-2 {margin: 0.5rem !important;}
            .mt-2,.my-2 {margin-top: 0.5rem !important;}
            .mr-2,.mx-2 { margin-right: 0.5rem !important; }
            .mb-2,.my-2 {margin-bottom: 0.5rem !important;}
            .ml-2,.mx-2 {margin-left: 0.5rem !important;}
            .m-3 { margin: 1rem !important;}
            .mt-3,.my-3 {margin-top: 1rem !important;}
            .mr-3,.mx-3 {margin-right: 1rem !important;}
            .mb-3,.my-3 {margin-bottom: 1rem !important;}
            .ml-3, .mx-3 {margin-left: 1rem !important; }
            .m-4 { margin: 1.5rem !important; }
            .mt-4, .my-4 {margin-top: 1.5rem !important;}
            .mr-4,.mx-4 { margin-right: 1.5rem !important;}
            .mb-4, .my-4 {margin-bottom: 1.5rem !important; }
            .ml-4,.mx-4 {margin-left: 1.5rem !important;}
            .m-5 {margin: 3rem !important; }
            .mt-5,.my-5 {margin-top: 3rem !important;}
            .mr-5,.mx-5 {margin-right: 3rem !important;}
            .mb-5, .my-5 { margin-bottom: 3rem !important;}
            .ml-5,.mx-5 { margin-left: 3rem !important; }
            .p-0 { padding: 0 !important;}
            .pt-0, .py-0 {padding-top: 0 !important;}
            .pr-0,.px-0 {padding-right: 0 !important;}
            .pb-0,.py-0 {padding-bottom: 0 !important;}
            .pl-0,.px-0 {padding-left: 0 !important;}
            .p-1 { padding: 0.25rem !important;}
            .pt-1, .py-1 {padding-top: 0.25rem !important;}
            .pr-1, .px-1 {padding-right: 0.25rem !important;}
            .pb-1,.py-1 { padding-bottom: 0.25rem !important;}
            .pl-1,.px-1 {padding-left: 0.25rem !important;}
            .p-2 {padding: 0.5rem !important;}
            .pt-2,.py-2 {padding-top: 0.5rem !important;}
            .pr-2, .px-2 {padding-right: 0.5rem !important;}
            .pb-2, .py-2 {padding-bottom: 0.5rem !important;}
            .pl-2,.px-2 {padding-left: 0.5rem !important;}
            .p-3 {padding: 1rem !important;}
            .pt-3, .py-3 {padding-top: 1rem !important;}
            .pr-3,.px-3 {padding-right: 1rem !important;}
            .pb-3, .py-3 {padding-bottom: 1rem !important; }
            .pl-3,.px-3 { padding-left: 1rem !important;}
            .p-4 {padding: 1.5rem !important; }
            .pt-4, .py-4 {padding-top: 1.5rem !important;}
            .pr-4,.px-4 {padding-right: 1.5rem !important;}
            .pb-4,.py-4 {padding-bottom: 1.5rem !important;}
            .pl-4,.px-4 {padding-left: 1.5rem !important; }
            .p-5 { padding: 3rem !important; }
            .pt-5, .py-5 {padding-top: 3rem !important;}
            .pr-5,.px-5 {padding-right: 3rem !important;}
            .pb-5,.py-5 {padding-bottom: 3rem !important;}
            .pl-5,.px-5 {padding-left: 3rem !important;}
            body{
                font-family: Arial, Helvetica, sans-serif;
            }
            .btn {
                display: inline-block;
                font-weight: 400;
                color: #212529;
                text-align: center;
                vertical-align: middle;
                -webkit-user-select: none;
                -moz-user-select: none;
                -ms-user-select: none;
                user-select: none;
                background-color: transparent;
                border: 1px solid transparent;
                padding: 0.375rem 0.75rem;
                font-size: 1rem;
                line-height: 1.5;
                border-radius: 0.25rem;
                transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
            }
            .btn:hover {
                color: #212529;
                text-decoration: none;
            }
            .btn-primary {color: #fff;background-color: #007bff; border-color: #007bff;}
            .btn-primary:hover {color: #fff;background-color: #0069d9;border-color: #0062cc;}
            .btn-success {color: #fff;background-color: #28a745;border-color: #28a745;}
            .btn-success:hover { color: #fff;background-color: #218838;border-color: #1e7e34;}
            .btn-danger {color: #fff;background-color: #d9534f;border-color: #d43f3a;}
            .btn-danger:hover {color: #fff;background-color: #c9302c;border-color: #ac2925;}

            input,button,select,optgroup,textarea {  margin: 0;font-family: inherit;font-size: inherit;line-height: inherit;}
            textarea {overflow: auto;resize: vertical;}
            textarea.form-control {height: auto;}

            .toggle {position: relative; display: inline-block; width: 48px; height:26px; float:right; margin-top:20px;} 
            .toggle input {display: none;}
            .shade {position: absolute; top: 0; left: 0; right: 0; bottom: 0; background-color: #ccc; }
            .shade:before {position: absolute; content: ""; height: 18px; width: 18px; left:4px; bottom: 4px; background-color: #fff; -webkit-transition: .4s; transition: .4s;}
            input:checked+.shade {background-color: #2196F3}
            input:checked+.shade:before {-webkit-transform: translateX(22px); -ms-transform: translateX(22px); transform: translateX(22px)}
      </style>
    </head>
    <body onload="iniPage()">
        <div class="container">
          <div id="content">
              <div class="row">
                <div class="col-12">
                  <h2>Setting Text on the ePaper</h2>
                </div>
              </div>
              <!--
              <div class="row">  
                <label class="col-4">Count LED:</label>
                <input type="text" id="countled">
              </div>
              //-->
              <div class="row mt-4">
                <label class="col-4 ">Text:</label>
                <input type="text" id="data" name="data">
              </div>
              
              <div class="row mt-4">
                <div class="col-12">
                  <input type="button" name="senddata" id="senddata" value="Send" onclick="sendData();" class="btn btn-success">
                </div>
              </div>
              
          </div>
        </div>
    <script>

    function sendData() {
      var data = document.getElementById("data").value;
    
      var xhr = new XMLHttpRequest();
      xhr.open("GET", "/setdata?data="+data, true); 
      xhr.send();
    }

    
    function iniPage(){
      var xhttp = new XMLHttpRequest();
      xhttp.onreadystatechange = function() {
        if (this.readyState == 4 && this.status == 200) {
          var stateArr = this.responseText.split("|");
          document.getElementById("data").value = stateArr[0];
        }
      };
      xhttp.open("GET", "/getdata", true);
      xhttp.send();     
    }
    

    </script>
    </body>
    </html>
)rawliteral";